# SysMedic UI v0.0.2 - Generic Linux Package

## Installation

### Automatic Installation (Recommended)
```bash
sudo ./scripts/install.sh
```

### Manual Installation
```bash
# Install binary
sudo cp bin/sysmedic-ui /usr/local/bin/
sudo chmod +x /usr/local/bin/sysmedic-ui

# Install desktop integration
sudo mkdir -p /usr/local/share/applications
sudo mkdir -p /usr/local/share/icons/hicolor/scalable/apps
sudo mkdir -p /usr/local/share/metainfo

sudo cp data/io.github.sysmedic.SysMedicUI.desktop /usr/local/share/applications/
sudo cp data/io.github.sysmedic.SysMedicUI.svg /usr/local/share/icons/hicolor/scalable/apps/
sudo cp data/io.github.sysmedic.SysMedicUI.appdata.xml /usr/local/share/metainfo/

# Update desktop database
sudo update-desktop-database /usr/local/share/applications/
sudo gtk-update-icon-cache /usr/local/share/icons/hicolor/
```

## Dependencies

Make sure the following dependencies are installed:
- GTK+ 3.22 or later
- GLib 2.56 or later
- libgee-0.8
- libjson-glib-1.0
- libsoup-2.4

### Ubuntu/Debian
```bash
sudo apt install libgtk-3-0 libglib2.0-0 libgee-0.8-2 libjson-glib-1.0-0 libsoup2.4-1
```

### Fedora/RHEL/CentOS
```bash
sudo dnf install gtk3 glib2 libgee json-glib libsoup
```

## Running

After installation, you can run SysMedic UI in several ways:
- From the applications menu: Look for "SysMedic UI"
- From the command line: `sysmedic-ui`
- From the desktop: Double-click the desktop file

## Uninstallation

```bash
sudo ./scripts/uninstall.sh
```

## Support

- GitHub: https://github.com/ahur-system/sysmedic-desktop-client
- Issues: https://github.com/ahur-system/sysmedic-desktop-client/issues

## License

MIT License - see LICENSE file for details.
