# SysMedic UI

A cross-platform desktop application for monitoring multiple Linux servers running SysMedic daemon. Built with Vala and GTK3, providing an intuitive graphical interface for system monitoring and user activity tracking.

## Version

**Current Version:** 0.0.1  
**Development Stage:** Initial project structure and build system setup

## Overview

SysMedic UI is designed to provide a centralized dashboard for monitoring multiple Linux servers from a single desktop application. The application connects to SysMedic daemon instances running on remote servers to collect real-time system metrics, user activity data, and server status information.

## Features (Planned)

- **Multi-Server Monitoring**: Monitor multiple servers from a single dashboard
- **Real-Time Metrics**: Live CPU, memory, network, and load average monitoring
- **User Activity Tracking**: Track resource usage by individual users
- **Smart Alerting**: Visual indicators for servers with issues or persistent problems
- **Secure Connections**: Support for API keys and basic authentication
- **Intuitive Interface**: Clean GTK3 interface with server sidebar and detailed panels
- **Connection Management**: Add, edit, remove, and test server connections
- **Status Indicators**: Visual status indicators for online/offline servers
- **Theme Integration**: Full GTK theme support including dark mode

## Current Status (v0.0.1)

This is the initial development version focusing on project infrastructure:

- ✅ **Project Structure**: Complete project structure with dual build system
- ✅ **Build System**: Meson (primary) and Make (compatibility) support
- ✅ **Development Environment**: Ready for core feature development
- ✅ **Documentation**: Project guidelines and development documentation
- ✅ **Testing Framework**: Basic testing scripts and development utilities

## Requirements

### Runtime Dependencies
- GTK+ 3.22 or later
- GLib 2.56 or later
- libgee-0.8
- libjson-glib-1.0
- libsoup-2.4

### Build Dependencies
- Vala compiler (valac) 0.48 or later
- Meson 0.56 or later
- Ninja build system (for Meson)
- Make (for compatibility builds)
- Development packages for runtime dependencies

## Building

### Quick Start

```bash
# Clone the repository
git clone https://github.com/ahur-system/sysmedic-desktop-client.git
cd sysmedic-desktop-client

# Install dependencies (Ubuntu/Debian)
make deps

# Build with Meson (recommended)
meson setup build --prefix=/usr/local
ninja -C build

# Or build with Make
make dev
```

### Build Options

#### Using Meson (Recommended)
```bash
# Setup build directory
meson setup build --prefix=/usr/local

# Build the application
ninja -C build

# Install system-wide
sudo ninja -C build install
```

#### Using Make (Compatibility)
```bash
# Install dependencies
make deps

# Build application
make

# Build with debug symbols
make dev

# Install system-wide
sudo make install
```

## Development

### Getting Started

1. **Clone Repository**: `git clone https://github.com/ahur-system/sysmedic-desktop-client.git`
2. **Install Dependencies**: `cd sysmedic-desktop-client && make deps`
3. **Build Application**: `make dev`
4. **Run Tests**: Execute available test scripts
5. **Read Documentation**: Review project documentation and guidelines

### Project Structure

```
sysmedic-desktop-client/
├── meson.build                # Primary build configuration
├── Makefile                   # Build convenience targets
├── README.md                  # This file
├── src/                       # Vala source code
│   ├── main.vala             # Application entry point
│   ├── application.vala      # GTK Application class
│   ├── window.vala          # Main window implementation
│   ├── models/              # Data models
│   ├── widgets/             # UI widget components
│   └── services/            # Business logic services
├── data/                     # Application resources
│   ├── ui/                  # GTK UI definitions
│   ├── css/                 # Custom styling
│   └── icons/               # Application icons
└── build/                   # Build output (generated)
```

### Development Roadmap

- **v0.0.2**: Basic GTK3 application framework and core widgets
- **v0.1.0**: Server management and connection testing
- **v0.2.0**: Real-time monitoring and metrics display
- **v1.0.0**: Feature-complete monitoring dashboard

### Code Style

- Follow Vala naming conventions
- Use 4 spaces for indentation
- Keep lines under 120 characters
- Add documentation for public methods
- Use descriptive variable names

## API Requirements

SysMedic UI expects the following API endpoints from the SysMedic daemon:

- `GET /api/status` - Server status and basic info
- `GET /api/metrics` - System metrics (CPU, memory, network, load)
- `GET /api/users` - User activity and resource usage
- `GET /api/alerts` - System alerts and notifications

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Related Projects

- **[SysMedic](https://github.com/ahur-system/sysmedic)** - The main SysMedic daemon
- **[SysMedic CLI](https://github.com/ahur-system/sysmedic)** - Command-line interface

## Support

- **Issues**: [GitHub Issues](https://github.com/ahur-system/sysmedic-desktop-client/issues)
- **Documentation**: [GitHub Wiki](https://github.com/ahur-system/sysmedic-desktop-client/wiki)
- **Discussions**: [GitHub Discussions](https://github.com/ahur-system/sysmedic-desktop-client/discussions)

## Contributing

Contributions are welcome! Please read the contributing guidelines and follow the established development workflow.

1. Fork the repository
2. Create a feature branch: `git checkout -b feature-name`
3. Make your changes following the code style guidelines
4. Test your changes with both build systems
5. Update documentation as needed
6. Submit a pull request

## Changelog

### [0.0.1] - 2024-01-15

#### Added
- Initial project structure with dual build system support
- Comprehensive project documentation and development guidelines
- Build system configuration for both Meson and Make
- Development testing framework and utilities
- GTK3/Vala application foundation ready for feature development

#### Technical
- Established widget architecture patterns for future development
- Created data model structure for server and metrics management
- Set up development environment with proper dependency management
- Implemented comprehensive .gitignore for clean repository management

---

**Note**: This is a development version. The application is not yet functional for end users but provides a solid foundation for feature development.